#ifndef __FIELD_H__
#define __FIELD_H__
#include "agent.h"

typedef long LOCATION;

#define X(l)		(((l) & 0xFFFF)-0x8000)
#define Y(l)		((((l)>>16) & 0xFFFF)-0x8000)
#define LOC(a,b)	((((a)+0x8000)&0xFFFF) + ((((b) + 0x8000)& 0xFFFF)<<16))

#define SEEDING_COMMAND_RECT	1
#define SEEDING_COMMAND_CIRCLE	0

typedef union{
struct {
	char *name;  /* name of the agent class to use for seeding */
	long type;   /* type of the command */
	long percent; /* percent of the agents to be actually seeded */
	} common;      /* common parameters */

struct {
	char *name;
	long type;
	long percent;
	long x1;
	long y1;
	long x2;
	long y2;
	} rect;
	
struct {
	char *name;
	long type;
	long percent;
	long x1;
	long y1;
	long r;
	} circle;
	
} SEEDING_COMMAND;

typedef struct S_FIELD {
	char *name;
	u64 id;
	AGENT * **agent;
	long x_size,y_size;
	LOCATION *neighbor;
	long num_neighbors;
	LOCATION current;
	long **shift_matrix;
	SEEDING_COMMAND **seeding_commands;
	long seeding_commands_size;
	long seeding_commands_free;
	long shift_matrix_x_size;
	long shift_matrix_y_size;
	int seeded;
	} FIELD;


void init_fields(void);
void reset_fields(void);
void clear_field(FIELD *f);
void free_field(FIELD *f);
void add_rect_seeding_command(FIELD *f,char *name, long x1, long y1, long x2,long y2, long percent);
void add_circle_seeding_command(FIELD *f,char *name, long x1, long y1, long r, long percent);
AGENT * get_agent(FIELD *f, LOCATION l);
FIELD * new_field(long x,long y);
FIELD * add_new_field(char *name,long x, long y);
void dump_fields(FILE *fout);
void seed_fields(void);
void execute_seeding_commands(FIELD *f);
FIELD *get_field(long index);
long num_fields(void);

#endif
